package some;

import java.util.HashMap;
import java.util.Map;

import net.w_horse.excelpojo.annotation.Bean;
import net.w_horse.excelpojo.annotation.LabeledCell;
import net.w_horse.excelpojo.annotation.MappedCell;
import net.w_horse.excelpojo.xml.tag.RetrieveType;

@Bean(retrieveType=RetrieveType.VERTICAL_REPEATS,
		label="ꗗ",
		terminate="Terminate",
		listClass="java.util.LinkedList")
public class UserInfo3 {
	@LabeledCell(label = "ID")
	private int id;
	@LabeledCell(label = "", margedRows=true)
	private String gender;
	@LabeledCell(label = "")
	private String firstName;
	@LabeledCell(label = "",  margedLabel=1)
	private String lastName;
	@LabeledCell(label = "[AhX")
	private String mailAddress;
	@MappedCell(previousLabel="[AhX")
	private Map<String, String> workingHours = new HashMap<String, String>();

	public String toString() {
		StringBuffer buff = new StringBuffer("UserInfo\t");
		buff.append("id=" + String.valueOf(getId()) + ", ");
		buff.append("gender=" + getGender() + ", ");
		buff.append("firstName=" + getFirstName() + ", ");
		buff.append("lastName=" + getLastName());

		buff.append(" Ǝ ");
		for (String month : workingHours.keySet()) {
			Object value = workingHours.get(month);
			buff.append(String.format(" %s=%s", month, value));
		}
		return buff.toString();
	}

	public void setId(int id) {
		this.id = id;
	}
	public int getId() {
		return id;
	}
	public void setGender(String gender) {
		this.gender = gender;
	}
	public String getGender() {
		return gender;
	}
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	public String getFirstName() {
		return firstName;
	}
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	public String getLastName() {
		return lastName;
	}
	public void setMailAddress(String mailAddress) {
		this.mailAddress = mailAddress;
	}
	public String getMailAddress() {
		return mailAddress;
	}

	public void setWorkingHours(Map<String, String> workingHours) {
		this.workingHours = workingHours;
	}

	public Map<String, String> getWorkingHours() {
		return workingHours;
	}


}
